/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Scriptable;

public final class NativeContinuation
extends IdScriptableObject
implements Function {
    static final long serialVersionUID = 1794167133757605367L;
    private static final Object FTAG = "Continuation";
    private Object implementation;
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeContinuation obj = new NativeContinuation();
        obj.exportAsJSClass(1, scope, sealed);
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public void initImplementation(Object implementation) {
        this.implementation = implementation;
    }

    public String getClassName() {
        return "Continuation";
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args2) {
        throw Context.reportRuntimeError("Direct call is not supported");
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        return Interpreter.restartContinuation(this, cx, scope, args2);
    }

    public static boolean isContinuationConstructor(IdFunctionObject f2) {
        return f2.hasTag(FTAG) && f2.methodId() == 1;
    }

    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        switch (id) {
            case 1: {
                arity = 0;
                s2 = "constructor";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(FTAG, id, s2, arity);
    }

    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(FTAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        switch (id) {
            case 1: {
                throw Context.reportRuntimeError("Direct call is not supported");
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    protected int findPrototypeId(String s2) {
        int id;
        block1: {
            id = 0;
            String X = null;
            if (s2.length() == 11) {
                X = "constructor";
                id = 1;
            }
            if (X == null || X == s2 || X.equals(s2)) break block1;
            id = 0;
        }
        return id;
    }
}

